% clc;
clear;
close all;
Re = 50; % Reynolds number
dp = 0.003; % Particle diameter
D_bed = 0.021; % Bed diameter
R_bed = D_bed / 2.;
rho = 1000; % Density
mu = 0.001; % Viscosity
% Putting all of the data from different subdomains in one file
str = num2str(Re);
projectdir = "Re" + str;
dinfo = dir( fullfile(projectdir, "Flow_Rate_"+str+".000000_*.txt")); % Location of the raw data
nfiles = length(dinfo);
filenames = fullfile(projectdir, {dinfo.name});
thisfile = filenames{1};
thisdata = load(thisfile);
[row, column] = size(thisdata);
data = zeros(row, 4 * (nfiles + 1));
for K = 1 : nfiles
    thisfile = filenames{K};
    thisdata = load(thisfile);
    data(:,4 * K - 3) = thisdata(:,1);
    data(:,4 * K - 2) = thisdata(:,2);
    data(:,4 * K - 1) = thisdata(:,3);
    data(:,4 * K) = thisdata(:,4);
end
[row, column] = size(data);
for i = 1:row
    data(i,column - 3) = data(i,1);
    data(i,column - 2) = sum(data(i,2:4:column - 6))/sum(data(i,3:4:column - 5));
    data(i,column - 1) = data(i, column - 2) * data(i, column - 4);
end
Flow_rate = sum(data(1:row, column - 1))
u_avg = (Re * mu)/(rho * dp);
% Calculating the normalized radial velocity
for i = 1:row
    data(i,column) = data(i,column - 2)/u_avg;
end
Flow_in = u_avg * pi * R_bed * R_bed
Flow_error = (abs(Flow_in - Flow_rate)/Flow_in) * 100
% Calculating the normalized cumulative flow rate
for i = 1:row
    cum(i,1) = sum(data(1:i, column-1))/Flow_in;
end
% Calculating the distance from the wall
for i = 1:row
    S(i,1) = (0.0105 - data(i,1))/0.003;
end